<?php 

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;


$db     = Factory::getDBO();
$price      = new PhocacartPrice();
$total          = $this->cart->getTotal();
$plugin    =PluginHelper::getPlugin('system','pcuikit_onepage');
$params     =new Registry($plugin->params);
$activetab = $params->get("activetab", 4);
$max_width = $params->get("max_width", "default");
$popupaddress = $params->get("popup_address", 1);
$checkout_guest = $params->get("checkout_guest","PLG_PCUIKIT_ONEPAGE_CHECKOUT_GUEST_TITLE");
$checkout_register = $params->get("checkout_register","PLG_PCUIKIT_ONEPAGE_CHECKOUT_GUEST_TITLE");

$checkout_title = $params->get("checkout_title", "PLG_PCUIKIT_ONEPAGE_CHECKOUT_TITLE");
$ordercomment = $params->get("show_comment", 0);
$hidetitles = "";
$sC = $this->cart->getShippingCosts();

$selected_shipmentid = 0;
if (!empty($sC["id"]))
$selected_shipmentid = $sC["id"];
?>

<div class="uk-width-1-1 uk-margin-bottom">
    <h3 class="uk-h3"><?php echo Text::_($checkout_title); ?></h3>
  </div>

<?php


$checkout_top_description = $params->get("checkout_top_description", "");
$checkout_bottom_description = $params->get("checkout_bottom_description", "");

$guest_checkout = $this->p->get('guest_checkout', 0);
$onlyguest =  $params->get('show_onlyguest',0);
if (empty($guest_checkout)) $onlyguest = 0;
$allowUserRegistration = ComponentHelper::getParams('com_users')->get('allowUserRegistration');


$user = Factory::getUser();
if($user->id == 0 && $guest_checkout)  
      { 
        $logindiv = 'display:none;';
      }
$pC = $this->cart->getPaymentCosts();
if (!empty($pC))
$paymentId = $pC["id"];
if (!empty($this->form)) {
$country_id = $this->form->getField('country')->value;
    if ($country_id > 0) { 
        
    $query = 'SELECT code2 AS value'
        . ' FROM #__phocacart_countries'
        . ' WHERE id = '.$country_id;
        $db->setQuery( $query );
        $country_id = $db->loadResult();
        $country_id = strtolower($country_id);
    }
}
if (isset($pC["method"]) && $pC["method"] == "payson_checkout") {
    $add_card = 0;
    foreach($this->fields['array'] as $k => $v) {
        if ($v->title == "jp_mailchimp_newsletter" || $v->title == "jp_acymailing_newsletter") { 

            $input = $this->form->getInput($v->title);
            $input = str_replace("form-control","form-control uk-input uk-margin-small",$input);
            $input = str_replace("form-check-input","form-check-input uk-margin-small-left",$input);
            if ($add_card == 0) { 
            ?>
<div class="uk-card uk-card-default uk-card-small uk-padding-small uk-margin-small-bottom">
<?php } $add_card = 1;?>



             <div class="uk-margin uk-form-horizontal ">
        <?php echo $v->label; ?>
        
            <?php echo $input; ?>
        
    </div>

            <?php
        }
    }
    if ($add_card == 1) echo "</div>"; 
    $payment        = new PhocacartPayment();
    $method = $payment->getPaymentMethod($pC["id"] );
    $params_old = $params;
    $params = $method->params;
    $sandbox    = $params->get('payson_checkout_onepage_test', 1);
    require_once JPATH_PLUGINS . '/pcp/payson_checkout/include.php';
    if (empty($sandbox)) {
        $apiUrl = \Payson\Payments\Transport\Connector::PROD_BASE_URL;
        $apiKey = $params->get('payson_checkout_onepage_secret', 1);
        $agentID = $params->get('livepaysonid', 1);
    } else {
        $apiUrl = \Payson\Payments\Transport\Connector::TEST_BASE_URL;
        $apiKey = $params->get('payson_checkout_onepage_test_secret', 1);
        $agentID = $params->get('paysonid', 1);
    }
    $connector = \Payson\Payments\Transport\Connector::init($agentID, $apiKey, $apiUrl);
    $checkoutClient = new \Payson\Payments\CheckoutClient($connector);
    $merchant_email         = $params->get('merchant_email', '');
    $address_override       = $params->get('address_override', '');
    $country_type           = $params->get('country_type', 1);

    $d['fullitems'] = $this->cart->getFullItems();
    $tax_price_total = 0;
    $final_price_total = 0;
    foreach($d['fullitems'][1] as $k => $v) {
        $producturl = PhocacartRoute::getItemRoute((int)$v['id'], (int)$v['catid'], $v['alias']);
        $imageurl = "";
       
        $tax_rate = intval(round($v["taxrate"] , 0, PHP_ROUND_HALF_DOWN)) ;
        $taxRateDecimal = $tax_rate / 100;
 
       
        $taxAmount = $v["netto"] * $taxRateDecimal;
        $v["tax"] = $taxAmount;
        $tax_price = intval(round($v["tax"]  , 0, PHP_ROUND_HALF_DOWN)) * $v["quantity"];
        $tax_price_total += $tax_price;
        $d1 = $v["netto"] + $v["tax"];
        $unit_price = round($d1  , 0, PHP_ROUND_HALF_DOWN);
        $final_price = $unit_price * $v["quantity"];
        $final_price_total += $final_price;

        $korder['cart']['items'][] = array(
            'reference'     => (string)$v['alias'],
            'name'          => substr(strip_tags($v['title']), 0, 127),
            'quantity'      => (int)$v["quantity"],
            'unitPrice'    => $unit_price,
            'taxRate'      => $taxRateDecimal,
        );
    }
    $paysonlocale = "en";
    if(!empty($params->get('payson_checkout_language')))
    {
        $paysonlocale = $params->get('payson_checkout_language');
    }
    $paysoncolor = "White";
    if(!empty($params->get('payson_checkout_color')))
    {
        $paysoncolor = $params->get('payson_checkout_color');
    }
    $currency  = PhocacartCurrency::getCurrency();
    if($currency->code == "EUR")
    {
        $payment_currency = "eur";
    }
    if($currency->code == "SEK")
    {
        $payment_currency = "sek";
    }
    $termsurl = $params->get('payson_checkout_onepage_terms');
    if(empty($termsurl)) $termsurl = URI::root ();
    $return         = URI::root(false). 'index.php?option=com_phocacart&view=response&task=response.paymentrecieve&type=payson_checkout&mid=1&pid='.(int)$paymentId.'&sid='.(int)$selected_shipmentid;
    $cancel_return  = URI::root(false). 'index.php?option=com_phocacart&view=response&task=response.paymentcancel&type=payson_checkout&mid=1&pid='.(int)$paymentId.'&sid='.(int)$selected_shipmentid;
    $notify_url     = URI::root(false). 'index.php?option=com_phocacart&view=response&task=response.paymentnotify&type=payson_checkout&pid='.(int)$paymentId.'&tmpl=component'.'&sid='.(int)$selected_shipmentid;
    $checkoutData = array(
            'customer' => array(
            'identityNumber' => '4605092222',
            'email' => 'tess.t.persson@test.se',
            'firstName' => 'Tess T',
            'lastName' => 'Persson',
            'postalCode' => '99999',
            'street' => 'Testgatan 1',
            'countryCode' => $country_id,
            'phone' => '0739000000',
            'city' => 'City',
            'type' => $params->get('customer_type')
        ),
          
            'order' => array(
                'currency' => $payment_currency,
                'items' => $korder['cart']['items']
            ),
            'merchant' => array(
                'termsUri' => $termsurl,
                'partnerId' => "Wnmedia",
                'checkoutUri' => $cancel_return ,
                'confirmationUri' => $return ,
                'notificationUri' =>$notify_url
            ),
            
            'gui' => array(
                'colorScheme' => $paysoncolor,
                'locale' => $paysonlocale,
                'requestPhone' => 1
            )
        );
        
        
        
        if (empty($sandbox)) {
            $checkoutData['customer'] = array(
                'countryCode' => $country_id,
                'type' => $params->get('customer_type')
            );
        }
        
        $paysonCheckout = $checkoutClient->create($checkoutData);
        $session = Factory::getSession ();
        $session->set('payson_order', $paysonCheckout['id']);
        echo $paysonCheckout['snippet'];  
    $params = $params_old;
 } elseif (isset($pC["method"]) && $pC["method"] == "klarna_checkout") {
    if ($selected_shipmentid > 0) {
    $add_card = 0;
    foreach($this->fields['array'] as $k => $v) {
        if ($v->title == "jp_mailchimp_newsletter" || $v->title == "jp_acymailing_newsletter") { 
            $input = '<div class="uk-form-horizontal ">
   <input type="checkbox" name="jform[jp_acymailing_newsletter]" id="jform_jp_acymailing_newsletter" class="uk-checkbox uk-margin-small-right" value="1" checked="checked">'.$v->label.'</div>';
            if ($add_card == 0) { 
            ?>
<div class="uk-card uk-card-default uk-card-small uk-padding-small uk-margin-small-bottom">
<?php } $add_card = 1;
    echo $input; 
    }
    }
    if ($add_card == 1) echo "</div>"; 
    $payment        = new PhocacartPayment();
    $method = $payment->getPaymentMethod($pC["id"] );
    $pmid = $pC["id"];
    $klarna_checkout_onepage_test = $method->params->get('klarna_checkout_onepage_test', 0);
    if ($klarna_checkout_onepage_test) {
        $merchantId = $method->params->get('klarna_checkout_onepage_test_eid', 0);
        $sharedSecret = $method->params->get('klarna_checkout_onepage_test_secret', 0);
        $url =  'https://api.playground.klarna.com';
    } else {
        $merchantId = $method->params->get('klarna_checkout_onepage_eid', 0);
        $sharedSecret = $method->params->get('klarna_checkout_onepage_secret', 0);
        $url =  'https://api.klarna.com';
    }
    if (!empty($merchantId) && !empty($sharedSecret)) {
        require_once JPATH_PLUGINS . '/pcp/klarna_checkout/src/vendor/autoload.php'; 
        $connector = \Klarna\Rest\Transport\Connector::create($merchantId, $sharedSecret, $url);
        $kco = new \Klarna\Rest\Checkout\Order($connector);

        $d['fullitems'] = $this->cart->getFullItems();
        $tax_price_total = 0;
        $final_price_total = 0;
        foreach($d['fullitems'][0] as $k => $v) {
            $producturl = PhocacartRoute::getItemRoute((int)$v['id'], (int)$v['catid'], $v['alias']);
            $imageurl = "";
            if (isset($v['image']) && $v['image'] != '') {
                if (empty($v['attributes'])) $v['attributes'] = "";
                $image = PhocacartImage::getImageDisplay($v['image'], '', PhocacartPath::getPath('productimage'), '', '', '', 'small', '', $v['attributes'], 2);
                if (isset($image['image']->rel)) {
                    $imageurl   = Uri::base(true).'/'.$image['image']->rel;

                }
            }

            if (isset($v["attributes"])) $v["default_price"] = $v["netto"];

            $d1 = $v["default_price"] * ( 1 + $v["taxrate"] / 100);
            $tax_rate = $v["taxrate"];
            $taxAmount = $d1 - $v["default_price"];
            $unit_price = round($d1 * 100 , 0, PHP_ROUND_HALF_DOWN);
            $tax_price = intval(round($taxAmount * 100 , 0, PHP_ROUND_HALF_DOWN)) * $v["quantity"];
            $tax_rate = round($tax_rate * 100  , 2, PHP_ROUND_HALF_DOWN);
            $tax_price_total += $tax_price;
            $final_price = $unit_price * $v["quantity"];
            $final_price_total += $final_price;
            $v['sku'] = trim($v['sku']);
            $query = 'SELECT sku FROM #__phocacart_product_stock WHERE product_key = "'.$v["idkey"].'"';
            $db->setQuery( $query );
            $sku = $db->loadResult();
            if(!empty($sku)) $v['sku'] = $sku;
            if (!empty($v['sku'])) $v['alias'] = $v['sku'];
            $korder['cart']['items'][] = array(
                'reference'     => (string)$v['alias'],
                'name'          => substr(strip_tags($v['title']), 0, 127),
                'quantity'      => (int)$v["quantity"],
                'unit_price'    => $unit_price,
                'product_url' => $producturl,
                'total_discount_amount' =>  0,
                        'total_tax_amount' => $tax_price,
                'discount_rate' => 0,
                        'tax_rate'      => $tax_rate,
                'total_amount' => $final_price,
                'image_url' => $imageurl
              );
        }
    }

    
    $pC = $this->cart->getPaymentCosts();
    if ($sC["brutto"] > 0) {
        if (empty($sC["netto"])) {
            $d1 = $sC["brutto"];
            $tax_rate = 0;
            $taxAmount = 0;
            $tax_price = 0;
        } else {
        $d1 = $sC["netto"] * ( 1 + $sC["taxrate"] / 100);
        $tax_rate = $sC["taxrate"] * 100;
        $tax_rate = round($tax_rate  , 2, PHP_ROUND_HALF_DOWN);
         $taxAmount = $d1 - $sC["netto"];
        $tax_price = intval(round($taxAmount * 100 , 0, PHP_ROUND_HALF_DOWN));
        }
        $unit_price = round($d1 * 100 , 0, PHP_ROUND_HALF_DOWN);
       
        $final_price_total = $final_price_total + $unit_price;
        $tax_price_total += $tax_price;
        $korder['cart']['items'][] = array(
                    'type'          => "shipping_fee",
                    'reference'     => "Shipping",
                    'name'          => substr($sC["bruttotxt"], 0, 127),
                    'quantity'      => 1,
                    'unit_price'    => $unit_price,
                    'discount_rate' => 0,
                     'tax_rate'      => $tax_rate,
                    'total_discount_amount' =>  0,
                     'total_tax_amount' => $tax_price,
                    'total_amount' => $unit_price
                );
        }
       

if ($pC["brutto"] > 0) {
$shipping_fee = intval(round($pC["brutto"] * 100 , 0, PHP_ROUND_HALF_DOWN));

$final_price_total = $final_price_total + $shipping_fee;

$korder['cart']['items'][] = array(
                    'type'          => "physical",
                    'reference'     => "Payment",
                    'name'          => substr($pC["bruttotxt"], 0, 127),
                    'quantity'      => 1,
                    'unit_price'    => $shipping_fee,
                    'discount_rate' => 0,
                    'tax_rate'      => 0,
                    'total_discount_amount' =>  0,
                    'total_tax_amount' =>0,
                    'total_amount' => $shipping_fee
                );
}

$coupon_discount = intval(round($total[0]["brutto_tax"] * 100 , 0, PHP_ROUND_HALF_DOWN));
$coupon_fee = $coupon_discount - $final_price_total;
if ($final_price_total > $coupon_discount && $coupon_fee < -200) {
    
    $final_price_total = $final_price_total + $coupon_fee;
    $korder['cart']['items'][] = array(
                        'type'          => "discount",
                        'reference'     => "Discount",
                        'name'          =>  Text::_('COM_PHOCACART_DISCOUNT'),
                        'quantity'      => 1,
                        'unit_price'    => $coupon_fee,
                        'discount_rate' => 0,
                        'tax_rate'      => 0,
                        'total_discount_amount' =>  0,
                        'total_tax_amount' => 0,
                        'total_amount' => $coupon_fee
    
                      );
        
}

    $korder["order_amount"]     = $final_price_total;

    $korder["order_tax_amount"] = $tax_price_total;

    $korder['purchase_country'] = "SE";
    if (!empty($country_id)) {
    $korder['purchase_country'] = strtoupper($country_id);
    }

$country_id = $this->form->getField('country')->value;


    $korder['purchase_currency'] = "EUR";
    $klarnasupported_locale = array();
        $klarnasupported_locale[] = 'de-at';
        $klarnasupported_locale[] = 'fr-be';
        $klarnasupported_locale[] = 'nl-be';
        $klarnasupported_locale[] = 'de-dk';
        $klarnasupported_locale[] = 'fi-fi';
        $klarnasupported_locale[] = 'fr-fr';
        $klarnasupported_locale[] = 'de-de';
        $klarnasupported_locale[] = 'it-it';
        $klarnasupported_locale[] = 'nl-nl';
        $klarnasupported_locale[] = 'no-no';
        $klarnasupported_locale[] = 'pl-pl';
        $klarnasupported_locale[] = 'es-es';
        $klarnasupported_locale[] = 'se-se';
        $klarnasupported_locale[] = 'fr-ch';
        $klarnasupported_locale[] = 'de-ch';
        $klarnasupported_locale[] = 'it-ch';
        $klarnasupported_locale[] = 'en-gb';
        $klarnasupported_locale[] = 'en-us';

    $klarna_checkout_onepage_language = $method->params->get('klarna_checkout_onepage_language', 0);
    $klarna_checkout_onepage_locale = $method->params->get('klarna_checkout_onepage_locale', 0);

    if($klarna_checkout_onepage_language == "1")
        {
            $korder['locale'] = $method->params->get('klarna_checkout_onepage_locale', "sv-se");
            
        }
        else if($klarna_checkout_onepage_language == "2")
        {
            
            $lang = Factory::getLanguage();
            $joomla_langtag = strtolower($lang->getTag());
            
            if(in_array($joomla_langtag, $klarnasupported_locale))
            {
                $korder['locale'] = $joomla_langtag;
            }
            else
            {
                $korder['locale'] = $klarna_checkout_onepage_locale;
            }


            
        }
        else
        {
            $korder['locale'] = $klarna_checkout_onepage_locale;
        }
        $klarnalocale = $korder['locale'];
        $klarnacurrency = "EUR";
        $currency  = PhocacartCurrency::getCurrency();
        $klarnacurrency = $currency->code;
    
            
             $korder['purchase_currency'] = $klarnacurrency;

            $countryselection = $method->params->get('countryselection', 0);

            if ($countryselection)
        {
        
        if ($country_id == 203) {
            $korder['purchase_currency'] = "SEK";
            $korder['purchase_country'] = "SE";
            
        }else if ($country_id == 2922) {
            $korder['purchase_currency'] = "EUR";
        }else if ($country_id == 223) {
            $korder['purchase_currency'] = "USD";
            $korder['purchase_country'] = "US";
        }else if ($country_id == 57) {
            $korder['purchase_currency'] = "DKK";
            $korder['purchase_country'] = "DK";
        } else if ($country_id == 222) {
            $korder['purchase_currency'] = "GBP";
             $korder['purchase_country'] = "GB";
        }  else if ($country_id == 14) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "AT";
        }else if ($country_id == 72) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "FI";
        }else if ($country_id == 81) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "DE";
        }else if ($country_id == 150) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "NL";
        }else if ($country_id == 160) {
            $korder['purchase_currency'] = "NOK";
             $korder['purchase_country'] = "NO";
        }else if ($country_id == 105) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "IT";
        }else if ($country_id == 195) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "ES";
        }else if ($country_id == 21) {
            $korder['purchase_currency'] = "EUR";
             $korder['purchase_country'] = "BE";
        }else if ($country_id == 13) {
            $korder['purchase_currency'] = "AUD";
             $korder['purchase_country'] = "AU";
        }else
            $korder['purchase_currency'] = "EUR";

        }

        $db->setQuery("SELECT code3 FROM #__phocacart_countries WHERE published = 1");
        $shippingcountries = $db->loadColumn();

        if (count($shippingcountries) > 0) {
            $korder['shipping_countries'] = $shippingcountries;
        }
        
    $termsurl = URI::root ();
    $korder['merchant']['id'] = $merchantId;
    $korder['merchant_urls']['terms'] = $method->params->get('klarna_checkout_onepage_terms', $termsurl);


    $session = Factory::getSession();

        $session_id = $session->getId();

        $session_name = $session->getName();

    $korder['merchant_urls']['checkout'] = JROUTE::_ (URI::root () .

            'index.php?option=com_phocacart&view=checkout&klarna_order={checkout.order.id}');

     $korder['merchant_urls']['confirmation'] = URI::root(false). 'index.php?option=com_phocacart&view=response&task=response.paymentrecieve&type=klarna_checkout&mid=1&pid='.(int)$paymentId.'&klarna_order={checkout.order.id}'.'&sid='.(int)$selected_shipmentid;

          $korder['merchant_urls']['push'] = URI::root () .

            'index.php?option=com_phocacart&tmpl=component&task=pluginNotificationpush&view=checkout&klarna_order={checkout.order.id}';

        $accept_customer = $method->params->get('accept_customer', 0);
       if($accept_customer == 2)
              {
                  $korder['options']['allowed_customer_types'] = ["person", "organization"];
              }
              if($accept_customer == 1)
              {
                 $korder['options']['allowed_customer_types'] = ["organization"];
                 $korder['customer']['type'] = "organization";
              }
               if($accept_customer == 0)
              {
                $korder['options']['allowed_customer_types'] = ["person"];
                $korder['customer']['type'] = "person";
              }
        $korder["order_lines"] = $korder['cart']['items'];
        unset($korder['cart']);
        unset($korder['gui']);
        unset($korder['merchant']);
        $kco->create($korder);
        $kco->fetch();
        echo $kco["html_snippet"];
    }
 } else { 

?>

<div class="uk-card uk-card-body uk-card-default uk-card-small">

    <?php 
  if (!empty($checkout_top_description)) {
    echo "<div class='uk-width-1-1 uk-margin-small'>";
    echo $checkout_top_description;
    echo "</div>";
    
  }
  ?>


    <?php
    if(empty($user->id) && $guest_checkout)  
      { 
        if (!$onlyguest) { 


    echo '<div class="uk-width-1-1 uk-button-group uk-margin-small-bottom" id="loginbtns" data-uk-button-radio>';
                 echo '<a id="regbtn" href="javascript:void(0);"  onclick="changemode(2);" class="uk-button uk-width-1-2 uk-button-primary">'.Text::_("COM_PHOCACART_CONFIG_CHECKOUT_LABEL").'</a>';
                 echo '<a id="loginbtn" href="javascript:void(0);" onclick="changemode(1);" class="uk-button uk-width-1-2">'.Text::_("COM_PHOCACART_LOGIN").'</a>';
                 echo '</div>';
                 
        }

        if ($allowUserRegistration && !$onlyguest) { 
            echo '<hr />';
    ?>
        <div class="billto-shipto">
         <div class="uk-width-1-1 uk-margin-bottom" >
            <div class="uk-button-group uk-width-1-1" data-uk-button-radio="">
                 <?php if (!$onlyguest) { ?>
               <a id="guestchekcout" class="uk-button uk-width-1-2 uk-button-primary" onClick="changecheckout(1)" href="javascript:void(0);"><i id="guesticon" class="icon-play uk-margin-small-right"></i><?php echo Text::_("COM_PHOCACART_GUEST"); ?></a>
               <a id="regcheckout"  class="uk-button uk-width-1-2" onClick="changecheckout(2)" href="javascript:void(0);"><i id="regicon" class="uk-margin-small-right"></i><?php echo Text::_("COM_PHOCACART_REGISTER"); ?></a>
               <?php } ?> 
            </div>
           </div>
        </div>
        
<?php } 
}
if($guest_checkout || !empty($user->id))  { 
 ?>

<div id="other-things">

    <?php
        if (!empty($checkout_guest) && empty($user->id) && $allowUserRegistration ) { 
    ?>

    <h4 id="guesttitle" class="uk-h4 uk-margin-top  <?php echo $hidetitles; ?>" ><?php echo Text::_($checkout_guest) ?></h4>
<?php } if (!empty($checkout_register) && $allowUserRegistration && !$onlyguest) {  ?>
                     <h4 id="regtitle" style="display:none" class="uk-h4 uk-margin-top  <?php echo $hidetitles; ?>" ><?php echo Text::_($checkout_register) ?></h4>
        <?php } ?>

    <form name="pcaddressform" id="pcaddressform" action="<?php echo $this->t['linkcheckout']; ?>" method="post">
        <?php 
            if ($allowUserRegistration && !$onlyguest) { 
                 $lang = Factory::getLanguage();
                $lang->load('com_users');
        ?>
        <div id="user_fields_div" style="display:none">
            <div class="uk-width-1-1 uk-margin-small">
                <input class="uk-input" placeholder="<?php echo Text::_('COM_USERS_LOGIN_USERNAME_LABEL'); ?>" type="text" id="username_field" name="jform[username]">
            </div>

            <div class="uk-width-1-1 uk-margin-small">
                <input class="uk-input" placeholder="<?php echo Text::_('COM_USERS_PROFILE_PASSWORD1_LABEL'); ?>" type="password" id="password_field" name="jform[password1]">
            </div>

            <div class="uk-width-1-1 uk-margin-small">
                <input class="uk-input" placeholder="<?php echo Text::_('COM_USERS_PROFILE_PASSWORD2_LABEL'); ?>" type="password" id="password1_field" name="jform[password2]">
            </div>
            <hr class="uk-divider-icon">
        </div>

        <?php
    }

$jp_acymailing_newsletter = 0;      
foreach($this->fields['array'] as $k => $v) {
    if ($v->display_billing == 1) {
        if ($v->title == "jp_mailchimp_newsletter" || $v->title == "jp_acymailing_newsletter") {
            $jp_acymailing_newsletter = $v->label;
            continue;
        } 
        if ($v->title == "country" || $v->title == "region") continue;
        ?>
        <div class="uk-width-1-1 uk-margin-small">
            <?php
                $input = $this->form->getInput($v->title);
                $input = str_replace("<input","<input placeholder='".Text::_($v->label)."'",$input);
                $input = str_replace("form-control","form-control uk-input",$input);
                echo $input;
            ?>
            
        </div>
    <?php
    }
} // for each
if($ordercomment){
    ?>
<div class="uk-margin-small">
     <textarea class="uk-textarea" id="phcomment" name="phcomment" rows="3" placeholder="<?php echo Text::_('COM_PHOCACART_COMMENT'); ?>"></textarea>
</div>
<?php } ?>
    <p  class="uk-text-large uk-margin-small uk-text-primary uk-text-bold uk-text-center"><?php echo Text::_('COM_PHOCACART_TOTAL'); ?>:&nbsp;<?php echo $price->getPriceFormat($total[0]['brutto']); ?></p>

    <div class="uk-width-1-1 uk-margin-top" > 
     <div class="shipto_fields_div">
        <div class="uk-width-1-1">
          <a  class="uk-button uk-button-default uk-width-1-1" href="#" uk-toggle="target:#shiptopopup"><i  class="uk-icon uk-icon-play uk-margin-right"></i><?php echo Text::_('PLG_SYSTEM_PCUIKIT_CHANGE_SHIP_ADDRESS'); ?></a>
         </div>
      </div>
      <div class="clear"></div>
  </div>

  <?php 
  if ($jp_acymailing_newsletter) { ?>
     <div class="uk-margin-small">
<label class="uk-text-small uk-text-middle">
<input type="checkbox" name="jform[jp_acymailing_newsletter]" id="jform_jp_acymailing_newsletter" class="uk-checkbox" value="1" checked="checked">
<?php echo $jp_acymailing_newsletter; ?>
</label>
</div>
<?php
  }
     if ($this->t['display_checkout_newsletter_checkbox'] > 0) 
    { 
       
    ?> <!-- start of newsletter -->
   <div class="uk-margin-small">
<label class="uk-text-small uk-text-middle">
<input type="checkbox" class="uk-checkbox uk-margin-small-right" id="newsletter" name="newsletter" value="1">
<?php echo strip_tags($this->t['checkout_newsletter_checkbox_label_text']); ?>
</label>
</div>
 <?php }  
if ($this->t['display_checkout_toc_checkbox'] > 0) { 
    $required_toc       = $this->t['display_checkout_toc_checkbox'] == 2 ? 'required="" aria-required="true"' : '';
    $check_terms =  $params->get('check_terms',0);
    ?>

     <div class="uk-margin-small">
        <label class="uk-text-small uk-text-middle">
            <input type="checkbox" class="uk-checkbox" id="phcheckouttac" name="phcheckouttac" <?php echo $required_toc; if ($check_terms == 1) { echo 'checked'; }?>>
            <?php if (!empty($this->t['terms_conditions_custom_label_text'])) { ?>
            <a  class="uk-link uk-text-small uk-text-middle" uk-toggle="target:#full-tos" tabindex="0" role="button"><?php echo Text::_('COM_PHOCACART_I_HAVE_READ_AND_AGREE_TO_THE')." ".Text::_('COM_PHOCACART_TERMS_AND_CONDITIONS'); ?></a>
            <?php
            } else {
            echo str_replace("<a","<a class='uk-link '",$this->t['terms_conditions_label_text']);
            }
              ?>
        </label>
        <?php if (!empty($this->t['terms_conditions_custom_label_text'])) { ?>
        <!-- terms -->
            <div id="full-tos" class="uk-modal" uk-modal>
          <div class="uk-modal-dialog uk-modal-body uk-text-left">
            <!--<a class="uk-modal-close uk-close"></a>-->
            <button class="uk-modal-close-default uk-close-large" type="button" uk-close></button>
             
            <?php echo $this->t['terms_conditions_label_text']; ?>
            
          </div>
     </div>
        <!-- terms end -->
    <?php } ?>
    </div>
<?php } 
if ($this->t['display_checkout_privacy_checkbox'] > 0) { 
    $required_privacy       = $this->t['display_checkout_privacy_checkbox'] == 2 ? 'required="" aria-required="true"' : '';
    $check_privacy =  $params->get('check_privacy',0);
    ?>

     <div class="uk-margin-small">
        <label class="uk-text-small uk-text-middle">
            <input type="checkbox" class="uk-checkbox" id="privacy" name="privacy" <?php echo $required_privacy; if ($check_privacy == 1) { echo 'checked'; }?>>
            <a  class="uk-link uk-text-small uk-text-middle" uk-toggle="target:#full-privacy" tabindex="0" role="button"><?php echo Text::_('COM_PHOCACART_FIELD_PRIVACY_AGREED_LABEL'); ?></a>
            
        </label>
        <!-- privacy -->
            <div id="full-privacy" class="uk-modal" uk-modal>
          <div class="uk-modal-dialog uk-modal-body uk-text-left">
            
            <button class="uk-modal-close-default uk-close-large" type="button" uk-close></button>
             
            <?php echo $this->t['checkout_privacy_checkbox_label_text']; ?>
            
          </div>
     </div>
        <!-- privacy end -->

    </div>
<?php } 
if ($this->t['enable_captcha_checkout']) { ?>
    
    <div class="uk-margin-small">
        <?php
   
            echo '<label id="jform_question_captcha-lbl" for="jform_question_captcha" class="hasPopover required" title="" data-content="'.Text::_('COM_PHOCACART_PLEASE_PROVE_THAT_YOU_ARE_HUMAN').'" data-original-title="'.Text::_('COM_PHOCACART_SECURITY_CHECK').'">'.Text::_('COM_PHOCACART_SECURITY_CHECK').'<span class="star">&nbsp;*</span></label>';
            echo '<div class="">'.PhocacartCaptchaRecaptcha::render().'</div>';

        ?>
    </div>

    <?php }
  if (!empty($checkout_bottom_description)) {
    echo "<div class='uk-width-1-1 uk-margin-small'>";
    echo $checkout_bottom_description;
    echo "</div>";
    
  }
  ?>

    <button type="submit" class="uk-button uk-button-primary uk-button-large uk-margin-top uk-width-1-1" href="javascript:void(0);"><span> <?php echo Text::_('COM_PHOCACART_CONFIRM_ORDER'); ?>  </span>
    </button>
    <input  type="hidden" name="register" id="register" value="0" />
<?php
    echo '<input type="hidden" name="task" id="task" value="" />'. "\n";
    echo '<input type="hidden" name="tmpl" value="component" />';
    echo '<input type="hidden" name="phcheckoutbsas" id="phcheckoutbsas" value="1" />';
    echo '<input type="hidden" name="option" value="com_phocacart" />'. "\n";
    echo '<input type="hidden" name="return" value="'.$this->t['actionbase64'].'" />'. "\n";
    echo "<div id='formcode'>".HTMLHelper::_('form.token')."</div>";
    echo '</form>'. "\n";
    ?>
    
     </form>
</div> <!-- end of other-things div-->
 <?php

}
    if(empty($user->id))  
      {

$login_title = $params->get("login_title", "COM_PHOCACART_PLEASE_LOGIN");
       ?>
    <div id="logindiv" class="uk-margin-top" style="<?php echo $logindiv; ?>">
        <h4 class="uk-h4"><?php echo Text::_($login_title) ?></h4>
        <?php
        $lang = Factory::getLanguage();
        $lang->load('com_users');
        $show_forget =  $params->get('show_forget',1);
        $url = Uri::getInstance()->toString();
        $return = base64_encode($url);
          ?>
        <form id="login-form" action="<?= Route::_('index.php', true) ?>" method="post">
        <div class=" uk-width-1-1">
            <div class="username uk-inline uk-width-1-1 uk-margin-small-top " id="com-form-login-username">
                <div class="uk-inline uk-width-1-1">
                   <?php
                    if($show_forget)
                    {
                    ?>
                    
                    <a class="uk-form-icon uk-form-icon-flip" uk-icon="icon: user" uk-tooltip="<?php echo Text::_('COM_USERS_LOGIN_REMIND'); ?>" title="<?php echo Text::_('COM_USERS_LOGIN_REMIND'); ?>"  href="<?php echo Route::_('index.php?option=com_users&view=remind'); ?>"></a>
                    <?php
                    }
                    ?>
                    <input required="" id="userlogin_username" class="uk-input uk-width-1-1 required" type="text" name="username"  alt="<?php echo Text::_('COM_USERS_LOGIN_USERNAME_LABEL'); ?>" value="" placeholder="<?php echo Text::_('COM_USERS_LOGIN_USERNAME_LABEL'); ?>" />
                </div>
            </div>
            
            <div class="password uk-width-1-1 uk-margin-small-top  uk-margin" id="com-form-login-password">
                <div class="uk-inline uk-width-1-1">
                   <?php
                    if($show_forget)
                    {
                    ?>

                    <a  class="uk-form-icon uk-form-icon-flip" uk-icon="icon: lock"  uk-tooltip="<?php echo Text::_('COM_USERS_LOGIN_RESET'); ?>" title="<?php echo Text::_('COM_USERS_LOGIN_RESET'); ?>"  href="<?php echo Route::_('index.php?option=com_users&view=reset'); ?>"></a>

                    <?php
                    }
                    ?>
                    <input required="" id="userlogin_password" type="password" name="password" class="uk-input uk-width-1-1 required" size="18" alt="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>" value="" placeholder="<?php echo Text::_('JGLOBAL_PASSWORD'); ?>" />
                </div>
            </div>

            <div class="login uk-width-1-1@l uk-width-1-1@s uk-margin-small-top" id="com-form-login-remember">
                 <button class="uk-button uk-button-primary uk-width-1-1" href="javascript:void(0);" type="submit"><?php echo Text::_('JLOGIN') ?></button>
            </div>
            <div class="clear"></div>
        </div>
        
        <input type="hidden" name="option" value="com_users">
        <input type="hidden" name="task" value="user.login">
        <input type="hidden" name="return" value="<?= $return ?>">
        <?= HTMLHelper::_('form.token') ?>
        </form>
    </div> 
<?php } ?>
</div>

<?php } ?>

<div id="shiptopopup" class="uk-modal" uk-modal><!-- Shipto Modal Started -->
     <div class="uk-modal-dialog uk-modal-body">
            <button class="uk-modal-close-default uk-close-large" type="button" uk-close></button>
           <div class="ukmodalheader uk-margin-small uk-text-large uk-text-bold"><strong><?php echo Text::_('PLG_SYSTEM_PCUIKIT_CHANGE_SHIP_ADDRESS_HEADING'); ?></strong></div>

           <form name="pcshipaddressform" id="pcshipaddressform" action="#" method="post">

           <?php
      
foreach($this->fields['array'] as $k => $v) {


    if ($v->display_shipping == 1) { 

         $title = $v->title. '_phs';

      //  if ($v->title == "country" || $v->title == "region") continue;
        ?>
        <div class="uk-width-1-1 uk-margin-small">
            <?php
                $input = $this->form->getInput($title);
                $input = str_replace("<input","<input placeholder='".Text::_($v->label)."'",$input);
                $input = str_replace("form-control","form-control uk-input",$input);
                $input = str_replace("form-select","form-select uk-select",$input);
                echo $input;
            ?>
            
        </div>
    <?php
    }
} // for each
    ?>
    
   
    <style>
     .removeshipto {
        padding: 6px;margin: 4px;line-height: 11px;letter-spacing: 1px;font-size: 8px;
     }
    </style>
      <div class="uk-margin-small  uk-modal-footer uk-padding-remove-left">
         <button type="submit" class="uk-button uk-button-primary" href="Javascript:void(0);" ><?php echo Text::_("JSUBMIT"); ?></button>
         <a id="shiptocancel" class="uk-modal-close uk-button"><?php echo Text::_("JCANCEL"); ?></a>
      </div>
  </div>
</div><!-- Shipto Modal ended -->

<script>
    var pcurl = "<?php echo Uri::base(true); ?>/index.php?option=com_phocacart&view=checkout";
</script>

<script>

function changecheckout(val)
{
  var isLoggedIn = <?php echo Factory::getUser()->guest ? 'false' : 'true'; ?>;
  if(val == 1)
  {
    jQuery("#regtitle").hide();
    jQuery("#guesttitle").show();

    jQuery("#guestchekcout").addClass("uk-button-primary");
    jQuery("#regcheckout").removeClass("uk-button-primary");
    jQuery("#regicon").removeClass("icon-play");
    jQuery("#guesticon").addClass("icon-play");
    
  
    jQuery('#register').val('0');
       jQuery('#user_fields_div').hide();
    
    
    
  }
  if(val == 2)
  {
     jQuery("#regtitle").show();
     jQuery("#guesttitle").hide();
     
     jQuery("#guestchekcout").removeClass("uk-button-primary");
     jQuery("#regcheckout").addClass("uk-button-primary");
     jQuery("#regicon").addClass("icon-play");
     jQuery("#guesticon").removeClass("icon-play");
     jQuery('#register').val('1');
        if (!isLoggedIn) {
      jQuery('#user_fields_div').show();
    } else {
      jQuery('#user_fields_div').hide();
    }
    
  }
}

function changemode(val)
{
  if(val == 1)
  {
    jQuery("#logindiv").slideDown();
    jQuery("#loginbtn").addClass("uk-button-primary");
    jQuery("#regbtn").removeClass("uk-button-primary");
    jQuery("#old_payments").slideUp();
    jQuery(".billto-shipto").slideUp();
    jQuery("#other-things").slideUp();
  }
  if(val == 2)
  {
     jQuery("#logindiv").slideUp();
     jQuery("#loginbtn").removeClass("uk-button-primary");
     jQuery("#regbtn").addClass("uk-button-primary");
     jQuery("#old_payments").slideDown();
     jQuery(".billto-shipto").slideDown();
     jQuery("#other-things").slideDown();
  }
}

jQuery("#jform_country").change(function(){
  setcountry();
});

jQuery("#jform_region").change(function(){
    setcountry();
});
function setcountry() {
  var country = jQuery("#jform_country").val() || "";
  var region  = 0;

  if (jQuery("#jform_region").length) {
    region = jQuery("#jform_region").val() || 0;
  }

  var fields = jQuery("#pcaddressform")
    .find(":input")
    .filter(function () {
      return jQuery.trim(this.value).length > 0;
    })
    .serializeArray();

  for (var i = 0; i < fields.length; i++) {
    if (fields[i].name === "register") {
      fields[i].value = "0";
      break;
    }
  }
  var $ph = jQuery('input[name^="phshippingmethodfield"]');
  if ($ph.length) {
    fields = fields.concat($ph.serializeArray());
  }

  fields.push({ name: "pctask", value: "addresschange" });
  fields.push({ name: "jform[country]", value: country });
  fields.push({ name: "jform[region]", value: region });
  fields.push({ name: "jform[jform_country_phs]", value: country });

  var datas = jQuery.param(fields);

  if (country !== "") {
    jQuery.ajax({
      type: "POST",
      cache: false,
      url: pcurl,
      dataType: "json",
      data: datas
    })
      .done(function () {
        location.reload();
      })
      .fail(function () {
        console.warn("Country change request failed.");
        location.reload(); 
      });
  }
}
var formsubmit = 0;
function setpayment(fees) {
    UIkit.modal("#lodingdiv").show();
    var selectedpayid = jQuery("input[name='phpaymentopt']:checked").val();

    if (selectedpayid > 0) {
         jQuery.ajax({
            type: "POST",
            cache: false,
            url: pcurl,
            dataType: "json",
            data : "pctask=setpayment&selectedpayid="+selectedpayid
       }).done(
       function (data, textStatus) 
       {
            if (data.message == "success") {
                UIkit.modal("#lodingdiv").hide();
                if (fees !=paycost) {
                    window.location.reload();
                }
            }
       });
    }
}

function setshipment(fees) {
    UIkit.modal("#lodingdiv").show();
    var selectedshipid = jQuery("input[name='phshippingopt']:checked").val();

    if (selectedshipid > 0) {
         jQuery.ajax({
            type: "POST",
            cache: false,
            url: pcurl,
            dataType: "json",
            data : "pctask=setshipment&shipmentid="+selectedshipid
       }).done(
       function (data, textStatus) 
       {
            if (data.message == "success") {
                UIkit.modal("#lodingdiv").hide();
                if (fees !=shipcost) {
                window.location.reload();
                }
            }
       });
    }
}

jQuery("#pcshipaddressform").submit(function(){
    UIkit.modal("#shiptopopup").hide();
    jQuery("#phcheckoutbsas").val(0);
    return false;
});
<?php 
if (!empty($this->form)) { ?>
jQuery("#pcaddressform").on("submit", function (e) {
  e.preventDefault();
  const country_id = "<?php echo $this->form->getField('country')->value ?>";
  const region_id  = "<?php echo $this->form->getField('region')->value ?>";

  if (typeof formsubmit !== "undefined" && formsubmit === 1) return true;
  const register = jQuery("#register").val();
  if (register == 1) {
    const username  = (jQuery("#username_field").val() || "").trim();
    const password  = (jQuery("#password_field").val() || "").trim();
    const password2 = (jQuery("#password1_field").val() || "").trim();

    const errs = [];
    if (!username) errs.push("Username should not be empty.");
    if (!password) errs.push("Password should not be empty.");
    if (!password2) errs.push("Password2 should not be empty.");
    if (password && password2 && password !== password2) {
      errs.push("<?php echo Text::_('COM_USERS_FIELD_RESET_PASSWORD1_MESSAGE'); ?>.");
    }

    if (errs.length) {
      jQuery("#customerror").show().html(errs.join("<br>"));
      jQuery("html, body").animate({ scrollTop: jQuery("#customerror").offset().top - 100 }, 1000);
      return false;
    }
  }

  let fields = jQuery("#pcaddressform, #pcshipaddressform").serializeArray();

  const $ph = jQuery('input[name^="phshippingmethodfield"]');
  if ($ph.length) fields = fields.concat($ph.serializeArray());
 
  fields.push({ name: "pctask", value: "addresschange" });
  const countryVal = jQuery("#jform_country").length
    ? (jQuery("#jform_country").val() || "")
    : "undefined";
  const regionVal = jQuery("#jform_region").length
    ? (jQuery("#jform_region").val() || "")
    : "undefined";

  fields.push({
    name: "jform[country]",
    value: countryVal && countryVal !== "undefined" ? countryVal : country_id
  });
  fields.push({
    name: "jform[region]",
    value: regionVal && regionVal !== "undefined" ? regionVal : region_id
  });

  const newsletter = jQuery("input[name='newsletter']:checked").val();
  if (newsletter == 1) fields.push({ name: "newsletter", value: "1" });
  const datas = jQuery.param(fields);

  UIkit.modal("#lodingdiv").show();
  jQuery.ajax({
    type: "POST",
    cache: false,
    url: pcurl,              
    dataType: "json",
    data: datas
  })
    .done(function (data, textStatus) {
      if (data && data.message === "success") {
        jQuery("#task").val("checkout.order");
        if (Object.prototype.hasOwnProperty.call(data, "formcode")) {
          jQuery("#formcode").html(data.formcode);
        }
        if (typeof formsubmit !== "undefined") {
          formsubmit = 1;
        }
        UIkit.modal("#lodingdiv").hide();
        jQuery("#pcaddressform")[0].submit();
      } else {
        UIkit.modal("#lodingdiv").hide();
        jQuery("#customerror").show().html((data && data.message) || "Unknown error");
        jQuery("html, body").animate({ scrollTop: jQuery("#customerror").offset().top - 100 }, 1000);
        return false;
      }
    })
    .fail(function (jqXHR) {
      UIkit.modal("#lodingdiv").hide();
      jQuery("#customerror").show().html("Request failed. Please try again.");
      jQuery("html, body").animate({ scrollTop: jQuery("#customerror").offset().top - 100 }, 1000);
      return false;
    });

  return false;
});
<?php } ?>
function applyrewards()
{
    var coupon_code = jQuery("#phreward").val().trim();
    if (coupon_code == "") {
            jQuery("#customerror").show();
            jQuery("#customerror").html("Reward Points should not be empty");
            jQuery('html, body').animate({
               scrollTop: $("#customerror").offset().top - 100
            }, 1000);
            return false;
    }

    UIkit.modal("#lodingdiv").show();
    jQuery.ajax({
            type: "POST",
            cache: false,
            url: pcurl,
            dataType: "json",
            data : "pctask=applyrewards&phreward="+coupon_code
       }).done(
       function (data, textStatus) 
       {
            if (data.message == "success") {
                 window.location.reload();
            } else {
                jQuery("#customerror").show();
                jQuery("#customerror").html(data.message);
                jQuery('html, body').animate({
               scrollTop: $("#customerror").offset().top - 100
            }, 1000);
            }
            UIkit.modal("#lodingdiv").hide();
       });
}
function applycoupon()
{
    var coupon_code = jQuery("#coupon_code").val().trim();
    if (coupon_code == "") {
            jQuery("#customerror").show();
            jQuery("#customerror").html("Coupon code should not be empty");
            jQuery('html, body').animate({
               scrollTop: $("#customerror").offset().top - 100
            }, 1000);
            return false;
    }

    UIkit.modal("#lodingdiv").show();
    jQuery.ajax({
            type: "POST",
            cache: false,
            url: pcurl,
            dataType: "json",
            data : "pctask=applycoupon&coupon="+coupon_code
       }).done(
       function (data, textStatus) 
       {
            if (data.message == "success") {
                 window.location.reload();
            } else {
                jQuery("#customerror").show();
                jQuery("#customerror").html(data.message);
                jQuery('html, body').animate({
               scrollTop: $("#customerror").offset().top - 100
            }, 1000);
            }
            UIkit.modal("#lodingdiv").hide();
       });
}
function deletecoupon()
{
    UIkit.modal("#lodingdiv").show();
    jQuery.ajax({
            type: "POST",
            cache: false,
            url: pcurl,
            dataType: "json",
            data : "pctask=deletecoupon"
       }).done(
       function (data, textStatus) 
       {
            if (data.message == "success") {
                 window.location.reload();
            } 
            UIkit.modal("#lodingdiv").hide();
       });
}


 var animate = setInterval(function () {
                                        
        if(jQuery("#progressbar_load_1").length > 0)
        {
           window.progressbar_load_1 && (progressbar_load_1.value += 20);
           if (!window.progressbar_load_1 || progressbar_load_1.value == progressbar_load_1.max) {
               progressbar_load_1.value = 0;
              
           }
        }
       }, 500);

       <?php 
        if ($activetab != 4) {
            if ($activetab == 3) { ?>
                 changemode(1);
                <?php
            } else { ?>
                 changecheckout(<?php echo $activetab; ?>);
                 <?php
            }
        }      

if ($max_width !="default" && !empty($max_width)) {
                ?>     
        jQuery("#tm-main .uk-container").addClass("uk-container-<?php echo $max_width; ?>");
        <?php } ?>
        <?php  
$ajax_zip = $params->get("ajax_zip", 0);
if ($ajax_zip) { ?>
    jQuery("#jform_zip").on('change', function() {
  setcountry();
});
    <?php
} ?>
</script>